unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CommCtrl, ComCtrls, Inifiles;

type
  TTrackBar = class(ComCtrls.TTrackBar)
    procedure CreateParams(var Params: TCreateParams); override;
  end;

  TConfigFrm = class(TForm)
    TrackBar1: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  Secao = 'Screen Saver.Ping';
var
  ConfigFrm: TConfigFrm;

implementation

{$R *.DFM}

procedure TTrackBar.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.Style := Params.Style and not TBS_ENABLESELRANGE;
end;

procedure TConfigFrm.FormCreate(Sender: TObject);
var
  Inifile : TInifile;
begin
  IniFile := TInifile.Create('CONTROL.INI');
  TrackBar1.Position := Inifile.ReadInteger(Secao,'Position',50);
  IniFile.Free;
end;

procedure TConfigFrm.Button1Click(Sender: TObject);
var
  Inifile : TInifile;
begin
  IniFile := TInifile.Create('CONTROL.INI');
  Inifile.WriteInteger(Secao,'Position',TrackBar1.Position);
  IniFile.Free;
  Close;
end;

procedure TConfigFrm.Button2Click(Sender: TObject);
begin
  Close;
end;

end.
